"use client";

import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Label } from "@/components/ui/label";
import { useState } from "react";
import { toast } from "@/hooks/use-toast";

export default function Home() {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
    message: ""
  });

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    toast({
      title: "Pesan Terkirim!",
      description: "Terima kasih telah menghubungi saya. Saya akan segera merespons pesan Anda.",
    });
    setFormData({ name: "", email: "", message: "" });
  };

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value
    });
  };

  const projects = [
    {
      title: "E-Commerce Platform",
      description: "Platform e-commerce modern dengan fitur pembayaran dan manajemen inventory",
      image: "/api/placeholder/400/300"
    },
    {
      title: "Mobile Banking App",
      description: "Aplikasi mobile banking dengan UI/UX yang intuitif dan aman",
      image: "/api/placeholder/400/300"
    },
    {
      title: "Portfolio Website",
      description: "Website portfolio yang elegan dan responsif untuk profesional kreatif",
      image: "/api/placeholder/400/300"
    },
    {
      title: "Task Management System",
      description: "Sistem manajemen tugas dengan fitur kolaborasi real-time",
      image: "/api/placeholder/400/300"
    },
    {
      title: "Social Media Dashboard",
      description: "Dashboard untuk mengelola multiple social media accounts",
      image: "/api/placeholder/400/300"
    },
    {
      title: "Learning Management System",
      description: "Platform pembelajaran online dengan fitur interaktif",
      image: "/api/placeholder/400/300"
    }
  ];

  const skills = [
    { name: "HTML/CSS", level: 95 },
    { name: "JavaScript", level: 90 },
    { name: "React", level: 85 },
    { name: "Next.js", level: 80 },
    { name: "TypeScript", level: 75 },
    { name: "Node.js", level: 70 }
  ];

  const socialLinks = [
    { name: "LinkedIn", icon: "🔗", url: "#" },
    { name: "GitHub", icon: "🐙", url: "#" },
    { name: "Twitter", icon: "🐦", url: "#" },
    { name: "Instagram", icon: "📷", url: "#" }
  ];

  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100">
      {/* Hero Section */}
      <section className="relative min-h-screen flex items-center justify-center px-4 py-20 overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-blue-900/5 to-gray-100"></div>
        <div className="relative z-10 max-w-6xl mx-auto text-center">
          <div className="mb-8 animate-fade-in">
            <div className="w-32 h-32 mx-auto mb-6 rounded-full overflow-hidden border-4 border-white shadow-lg">
              <div className="w-full h-full bg-gradient-to-br from-blue-600 to-blue-800 flex items-center justify-center text-white text-4xl font-bold">
                JD
              </div>
            </div>
          </div>
          
          <h1 className="text-5xl md:text-7xl font-bold mb-4 text-gray-900 animate-fade-in-up">
            John Doe
          </h1>
          <p className="text-xl md:text-2xl mb-8 text-gray-700 animate-fade-in-up-delay-100">
            Full Stack Developer & UI/UX Designer
          </p>
          <p className="text-lg mb-12 max-w-2xl mx-auto text-gray-600 animate-fade-in-up-delay-200">
            Menciptakan pengalaman digital yang menakjubkan dengan teknologi modern dan desain yang intuitif
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center animate-fade-in-up-delay-300">
            <Button 
              size="lg" 
              className="bg-blue-900 hover:bg-blue-800 text-white px-8 py-3 text-lg transition-all duration-300 transform hover:scale-105"
              onClick={() => document.getElementById('projects')?.scrollIntoView({ behavior: 'smooth' })}
            >
              Lihat Karya Saya
            </Button>
            <Button 
              variant="outline" 
              size="lg" 
              className="border-blue-900 text-blue-900 hover:bg-blue-900 hover:text-white px-8 py-3 text-lg transition-all duration-300"
              onClick={() => document.getElementById('contact')?.scrollIntoView({ behavior: 'smooth' })}
            >
              Hubungi Saya
            </Button>
          </div>
        </div>
      </section>

      {/* About Me Section */}
      <section id="about" className="py-20 px-4 bg-white">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-gray-900">Tentang Saya</h2>
            <div className="w-24 h-1 bg-gradient-to-r from-blue-600 to-blue-800 mx-auto mb-8"></div>
          </div>
          
          <div className="grid md:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <div className="flex items-center space-x-4">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                  💻
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-gray-900">Pengalaman</h3>
                  <p className="text-gray-600">5+ tahun dalam pengembangan web</p>
                </div>
              </div>
              
              <div className="flex items-center space-x-4">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                  🎨
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-gray-900">Keahlian</h3>
                  <p className="text-gray-600">Full Stack Development & UI/UX Design</p>
                </div>
              </div>
              
              <div className="flex items-center space-x-4">
                <div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                  🚀
                </div>
                <div>
                  <h3 className="text-xl font-semibold text-gray-900">Passion</h3>
                  <p className="text-gray-600">Menciptakan solusi digital yang inovatif</p>
                </div>
              </div>
            </div>
            
            <div className="bg-gray-50 p-8 rounded-lg">
              <p className="text-lg text-gray-700 leading-relaxed mb-6">
                Saya adalah seorang Full Stack Developer dan UI/UX Designer yang bersemangat dalam menciptakan pengalaman digital yang menakjubkan. Dengan pengalaman lebih dari 5 tahun, saya telah membantu berbagai klien mewujudkan visi digital mereka.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed">
                Saya percaya bahwa teknologi yang baik harus tidak hanya fungsional, tetapi juga indah dan mudah digunakan. Setiap proyek yang saya kerjakan adalah kesempatan untuk belajar hal baru dan menciptakan sesuatu yang bermakna.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Portfolio/Projects Section */}
      <section id="projects" className="py-20 px-4 bg-gray-50">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-gray-900">Portfolio Saya</h2>
            <div className="w-24 h-1 bg-gradient-to-r from-blue-600 to-blue-800 mx-auto mb-8"></div>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Beberapa proyek terbaik yang telah saya kerjakan dengan berbagai teknologi dan tantangan menarik
            </p>
          </div>
          
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {projects.map((project, index) => (
              <Card key={index} className="group overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1">
                <div className="aspect-video bg-gradient-to-br from-blue-600 to-blue-800 relative overflow-hidden">
                  <div className="absolute inset-0 bg-black/20 group-hover:bg-black/30 transition-colors duration-300"></div>
                  <div className="absolute inset-0 flex items-center justify-center text-white text-6xl opacity-50">
                    📱
                  </div>
                </div>
                <CardContent className="p-6">
                  <h3 className="text-xl font-semibold mb-2 text-gray-900">{project.title}</h3>
                  <p className="text-gray-600 mb-4">{project.description}</p>
                  <Button 
                    variant="outline" 
                    className="w-full border-blue-900 text-blue-900 hover:bg-blue-900 hover:text-white transition-all duration-300"
                  >
                    Lihat Detail
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Skills Section */}
      <section id="skills" className="py-20 px-4 bg-white">
        <div className="max-w-6xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-gray-900">Keahlian Saya</h2>
            <div className="w-24 h-1 bg-gradient-to-r from-blue-600 to-blue-800 mx-auto mb-8"></div>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Teknologi dan tools yang saya kuasai untuk menciptakan solusi digital yang berkualitas
            </p>
          </div>
          
          <div className="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            {skills.map((skill, index) => (
              <div key={index} className="space-y-2">
                <div className="flex justify-between items-center">
                  <span className="text-lg font-medium text-gray-900">{skill.name}</span>
                  <span className="text-sm text-gray-600">{skill.level}%</span>
                </div>
                <div className="w-full bg-gray-200 rounded-full h-3">
                  <div 
                    className="bg-gradient-to-r from-blue-600 to-blue-800 h-3 rounded-full transition-all duration-1000 ease-out"
                    style={{ width: `${skill.level}%` }}
                  ></div>
                </div>
              </div>
            ))}
          </div>
          
          <div className="mt-16 flex flex-wrap justify-center gap-4">
            {["React", "Next.js", "TypeScript", "Node.js", "Tailwind CSS", "MongoDB", "PostgreSQL", "Docker"].map((tech, index) => (
              <Badge key={index} variant="secondary" className="text-sm px-4 py-2 bg-blue-100 text-blue-900 hover:bg-blue-200 transition-colors duration-300">
                {tech}
              </Badge>
            ))}
          </div>
        </div>
      </section>

      {/* Contact Me Section */}
      <section id="contact" className="py-20 px-4 bg-gray-50">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-16">
            <h2 className="text-4xl md:text-5xl font-bold mb-4 text-gray-900">Hubungi Saya</h2>
            <div className="w-24 h-1 bg-gradient-to-r from-blue-600 to-blue-800 mx-auto mb-8"></div>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Saya selalu terbuka untuk diskusi tentang proyek menarik atau peluang kolaborasi
            </p>
          </div>
          
          <div className="grid md:grid-cols-2 gap-12">
            <div>
              <form onSubmit={handleSubmit} className="space-y-6">
                <div>
                  <Label htmlFor="name" className="text-gray-900">Nama</Label>
                  <Input
                    id="name"
                    name="name"
                    value={formData.name}
                    onChange={handleChange}
                    placeholder="Nama Anda"
                    className="mt-1 border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                    required
                  />
                </div>
                
                <div>
                  <Label htmlFor="email" className="text-gray-900">Email</Label>
                  <Input
                    id="email"
                    name="email"
                    type="email"
                    value={formData.email}
                    onChange={handleChange}
                    placeholder="email@example.com"
                    className="mt-1 border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                    required
                  />
                </div>
                
                <div>
                  <Label htmlFor="message" className="text-gray-900">Pesan</Label>
                  <Textarea
                    id="message"
                    name="message"
                    value={formData.message}
                    onChange={handleChange}
                    placeholder="Tulis pesan Anda di sini..."
                    rows={5}
                    className="mt-1 border-gray-300 focus:border-blue-500 focus:ring-blue-500"
                    required
                  />
                </div>
                
                <Button 
                  type="submit" 
                  className="w-full bg-blue-900 hover:bg-blue-800 text-white py-3 transition-all duration-300 transform hover:scale-105"
                >
                  Kirim Pesan
                </Button>
              </form>
            </div>
            
            <div className="space-y-8">
              <div>
                <h3 className="text-xl font-semibold mb-4 text-gray-900">Informasi Kontak</h3>
                <div className="space-y-3">
                  <div className="flex items-center space-x-3">
                    <div className="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                      📧
                    </div>
                    <span className="text-gray-700">john.doe@example.com</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                      📱
                    </div>
                    <span className="text-gray-700">+62 812 3456 7890</span>
                  </div>
                  <div className="flex items-center space-x-3">
                    <div className="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center text-blue-600">
                      📍
                    </div>
                    <span className="text-gray-700">Jakarta, Indonesia</span>
                  </div>
                </div>
              </div>
              
              <div>
                <h3 className="text-xl font-semibold mb-4 text-gray-900">Media Sosial</h3>
                <div className="flex space-x-4">
                  {socialLinks.map((social, index) => (
                    <a
                      key={index}
                      href={social.url}
                      className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center text-blue-600 hover:bg-blue-600 hover:text-white transition-all duration-300 transform hover:scale-110"
                      aria-label={social.name}
                    >
                      <span className="text-xl">{social.icon}</span>
                    </a>
                  ))}
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-gray-900 text-white py-8 px-4">
        <div className="max-w-6xl mx-auto text-center">
          <p className="text-gray-400">© 2024 John Doe. All rights reserved.</p>
          <p className="text-gray-500 mt-2">Dibuat dengan ❤️ menggunakan Next.js dan Tailwind CSS</p>
        </div>
      </footer>
    </div>
  );
}