import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Portfolio Pribadi - Modern & Elegan",
  description: "Portfolio pribadi yang modern dan elegan dengan nuansa minimalis. Menampilkan proyek, keterampilan, dan informasi kontak.",
  keywords: ["portfolio", "pribadi", "modern", "elegan", "minimalis", "web developer", "designer"],
  authors: [{ name: "Portfolio Owner" }],
  openGraph: {
    title: "Portfolio Pribadi",
    description: "Portfolio pribadi yang modern dan elegan dengan nuansa minimalis",
    url: "https://portfolio.example.com",
    siteName: "Portfolio Pribadi",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Portfolio Pribadi",
    description: "Portfolio pribadi yang modern dan elegan dengan nuansa minimalis",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-background text-foreground`}
      >
        {children}
        <Toaster />
      </body>
    </html>
  );
}
